/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.vw.api.VWException;
import filenet.vw.base.VWTokenHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWBootstrapURL;
import filenet.vw.soap.server.VWNoConnectionPointInSitePref;
import filenet.vw.soap.server.VWPreferencesHelper;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class VWSOAPSessionInfo {
    private static final Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static final String m_className = "VWSOAPSessionInfo";
    private String[] m_fullCPs = null;
    private String user = null;
    private String password = null;
    private String ceURI = null;

    public VWSOAPSessionInfo() {
    }

    protected static VWSOAPSessionInfo getSOAPSessionInfoFromToken(ServletContext application, HttpServletRequest request) throws VWException {
        String m_method = "getSOAPSessionInfoFromToken";
        String token = request.getHeader("X-Authorization");
        if (token == null) {
            throw new VWException("VWSOAPSessionInfo.verifyCredentials1", "Credentials are not available.");
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "getSOAPSessionInfoFromToken", token);
        }
        VWTokenHelper tk = VWTokenHelper.GetToken(token);
        if (logger.isFinest()) {
            logger.finest(m_className, "getSOAPSessionInfoFromToken", tk.toString());
        }
        return new VWSOAPSessionInfo(tk.getName(), tk.getPw(), tk.getCeURI(), new String[]{tk.getCp()});
    }

    protected VWSOAPSessionInfo(String user, String pw, String ceURI, String[] cps) throws VWException {
        this.user = user;
        this.password = pw;
        this.ceURI = ceURI;
        int nCps = cps == null ? 0 : cps.length;
        this.m_fullCPs = new String[nCps];
        for (int i = 0; i < nCps; ++i) {
            try {
                this.m_fullCPs[i] = VWBootstrapURL.GetBootstrapURI(this.ceURI, cps[i]);
                continue;
            }
            catch (Exception e) {
                throw new VWException(e);
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCEURI() {
        return this.ceURI;
    }

    public String getFullConnectionPoint() {
        if (this.m_fullCPs != null && this.m_fullCPs.length > 0) {
            return this.m_fullCPs[0];
        }
        return null;
    }

    public String toString() {
        return this.getFullConnectionPoint();
    }

    public String[] getConnectionPoints() {
        return this.m_fullCPs;
    }

    public static VWSOAPSessionInfo getSessionInfoFromWorkplace(ServletContext application, HttpServletRequest request) throws VWException {
        String m_method = "getSessionInfoFromWorkplace";
        try {
            return VWPreferencesHelper.getSessionInfoFromWorkplace(application, request);
        }
        catch (Throwable t) {
            Throwable realCause = VWException.getRealCause(t);
            logger.throwing(m_className, "getSessionInfoFromWorkplace", realCause);
            if (realCause instanceof VWNoConnectionPointInSitePref) {
                throw (VWNoConnectionPointInSitePref)realCause;
            }
            throw new VWException(realCause);
        }
    }
}

